/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 **************************************************************************//*!
 *
 * @file phd_device_spec.h
 *
 * @author
 *
 * @version
 *
 * @date June-16-2009

 * @brief This file contains macros and constants required by the various 
 *        device specializations
 *****************************************************************************/

#ifndef _PHD_DEVICE_SPEC_H
#define _PHD_DEVICE_SPEC_H

#include "types.h"
#if (defined LITTLE_ENDIAN)
#include "ieee11073_phd_types_kinetis.h"    /* IEEE11073 Data Structures */
#else
#include "ieee11073_phd_types.h"    /* IEEE11073 Data Structures */
#endif  
#include "ieee11073_nom_codes.h"    

/******************************************************************************
 * Constants - None
 *****************************************************************************/

/******************************************************************************
 * Macro's
 *****************************************************************************/

/* Pulse Oximeter */
#define PHD_OXI_CNFG_EVT_RPT_SIZE           116 
#define PHD_OXI_DIM_GET_RSP_SIZE            115
#define PHD_OXI_DIM_DATA_TX_SIZE            58



/*****************************************************************************
 * Types
 *****************************************************************************/
#pragma pack(1)
/* structure for the measurements that are changing */
typedef struct _phd_measurement
{
    AbsoluteTime msr_time;
    uint_16 weight[2];
    uint_16 bmi[2];
}PHD_MEASUREMENT, *PHD_MEASUREMENT_PTR;

#if defined(__CWCC__)
#pragma align_array_members off
#pragma options align=reset
#elif defined(__IAR_SYSTEMS_ICC__)
#pragma pack()
#endif

/*****************************************************************************
 * Global variables 
 *****************************************************************************/  
extern uint_16 scanReportNo;
/*****************************************************************************
 * Global Functions - None
 *****************************************************************************/
#endif